import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.sound.midi.*;

public class FiniteStateMusic
{	
	private Synthesizer mySynthesizer;
	private Sequencer mySequencer; 
	private Sequence mySequence;
	private Soundbank mySoundbank;
	private Instrument myInstruments[];
	private MidiChannel myMidiChannels[];
	
	private Vector MachineVector = new Vector();
	private String stringRepresentation;
	
	private int instrumentNumber = 0;
	private int currentIndex = 0;
	private int currentState = 0;
	private int machineLength = 0;
	private int numMachines = 0;


	public FiniteStateMusic(String thisFiniteMachine) 
	{
		// Create the array of machine objects
		if (validateString(thisFiniteMachine)
		{
			stringRepresentation = thisFiniteMachine;			
			machineLength = new Integer(thisFiniteMachine.substring(0,1)).intValue();
			numMachines = (thisFiniteMachine.length() - 1)/machineLength;			
						
			for (int i = 1; i < numMachines*machineLength; i+=machineLength)
			{
				// First Object, Index Number and 4 Attributes
				createMachineObject(new Integer(stringRepresentation.substring(i,i+1)),
							new Integer(stringRepresentation.substring(i+1,i+2)),
							new Integer(stringRepresentation.substring(i+2,i+3)),
							new Integer(stringRepresentation.substring(i+3,i+4)),
							new Integer(stringRepresentation.substring(i+4,i+5))
				);
				
				new Integer(stringRepresentation.substring(i+5,i+6)).intValue(),new Integer(stringRepresentation.substring(i+6,i+7)).intValue(),new Integer(stringRepresentation.substring(i+7,i+8)).intValue());
				
			}
			
			// Initialize Midi
			try
			{
			
				// Get the default Synthesizer
				if (mySynthesizer == null)
				{
					if ((mySynthesizer = MidiSystem.getSynthesizer()) == null) 
					{
						return;
					}
				} 
				mySynthesizer.open();  // Open the Synth
				
				// Get Default Soundbank
				mySoundbank = mySynthesizer.getDefaultSoundbank();
				
				// Get Instruments array
				if (mySoundbank != null)
				{
					myInstruments = mySoundbank.getInstruments();
					mySynthesizer.loadInstrument(myInstruments[instrumentNumber]);
				}
			
				// Get the MidiChannels
				myMidiChannels = mySynthesizer.getChannels();
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}     

		}
		else
		{
			System.out.println("This is not a valid machine string representation");
		}		
		
	}


	private boolean validateString(String toValidate)
	{
		returnValue = true;
		
		/* 
		String Format:
			0-9 Machine Length
			for 1 to Machine Length
				0-9 Machine Attribute
		*/
		
		// Check Machine Length, must be greater than MachineObject.minMachineLength.
		if (toValidate.substring(0,1) >= MachineObject.minMachineLength)
		{
			// Check String Length
			if (toValidate.length()-1) % new Integer(toValidate.substring(0,1)).intValue() == 0)
			{
				// Nothing else to check at this point	
			}
			else
			{
				returnValue = false;
			}
		}
		else
		{
			returnValue = false;
		}
		
		
		return returnValue;
	}
   	
	public static void main(String[] args)
	{
		String theString;
		int machineLength = 8;
		
		boolean goodValues = true;
		
		if (args.length > 0)
		{
			theString = args[0];
		}
		else
		{
			Random theRanGen = new Random();
			StringBuffer theRanString = new StringBuffer();

			// 10 Machines
			for (int i = 0; i < 10; i++)
			{
				// Object
				theRanString.append(theRanGen.nextInt(10));
				
				// State One Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State One Next Object State
				theRanString.append(theRanGen.nextInt(2));
				
				// State Two Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State Two Next Object State
				theRanString.append(theRanGen.nextInt(2));				

				// Attribute One: Length
				theRanString.append(theRanGen.nextInt(4));
				
				// Attribute Two: Volume
				theRanString.append(theRanGen.nextInt(4));
				
				// Attribute Three: ...
				theRanString.append(theRanGen.nextInt(10));
			}
			theString = theRanString.toString();				
		}
		
		if (theString.length() % machineLength == 0)
		{
			int totalMachines = theString.length()/machineLength;
			for (int i = 0; i < totalMachines; i++)
			{
				String subString = theString.substring(i*machineLength,i*machineLength+machineLength);
				if (new Integer(subString.substring(1,2)).intValue() > totalMachines - 1)
				{
					goodValues = false;
				}
				else if (new Integer(subString.substring(3,4)).intValue() > totalMachines - 1)
				{
					goodValues = false;
				}
			}

		}
		else
		{
			goodValues = false;
		}
		
		if (goodValues)	
		{
			FiniteStates theFiniteStates = new FiniteStates(theString);
			System.out.println(theFiniteStates.playMachine(0,0));
		}
		else
		{
			System.out.println("Not an appropriate string.  Please try again.");
		}
	}

	public String toString()
	{
		return stringRepresentation;
	}

	// This will change when we go to Midi or whatever
	public String playMachine(int startingIndex, int startingState)
	{
		StringBuffer playedString = new StringBuffer();
		boolean keepGoing = true;
		currentIndex = startingIndex;
		currentState = startingState;
		Integer firstObject = (Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnObject();
		playedString.append(firstObject.toString());
		
		int counter = 0;
		while (keepGoing)
		{
			Integer newObject = returnNextObject();
			playedString.append(newObject.toString());

			counter++;			
			if (counter >= 20)
			{
				keepGoing = false;
			}
		}
		
		return playedString.toString();
	}
	
	public Integer returnNextObject()
	{
		currentState = ((Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnNextObjectState(currentState)).intValue();
		currentIndex = ((Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnNextObjectIndex(currentState)).intValue();
		Integer newObject = (Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnObject();
		return newObject;
	}
	
   	public Object createMachineObject(Object thisObject, int stateOneNextObjectIndex, Object stateOneNextObjectState, Object stateTwoNextObjectIndex, Object stateTwoNextObjectState)
   	{
		MachineObject currentObject = new MachineObject(thisObject, currentIndex, stateOneNextObjectIndex, stateOneNextObjectState, stateTwoNextObjectIndex, stateTwoNextObjectState, attributeOne, attributeTwo, attributeThree);
		MachineVector.add(currentObject);
		
		return currentObject;
   	}
   					
	private class MachineObject
	{
		public static int minMachineLength = 5;
		
		private int stateOneNextObjectIndex;
		private int stateTwoNextObjectIndex;
		private int stateOneNextObjectState;
		private int stateTwoNextObjectState;
		private int thisObjectIndex;
		
		private Object thisObject;

		private int attributeOne;
		private int attributeTwo;
		private int attributeThree;

		
		MachineObject(Object thisObject, int thisObjectIndex, int stateOneNextObjectIndex, int stateOneNextObjectState, int stateTwoNextObjectIndex, int stateTwoNextObjectState, int attributeOne, int attributeTwo, int attributeThree)		
		{
			this.thisObject = thisObject;
			setThisIndex(thisObjectIndex);
			setNextObjectIndex(stateOneNextObjectIndex, stateOneNextObjectState,1);
			setNextObjectIndex(stateTwoNextObjectIndex, stateTwoNextObjectState,2);
			setAttributes(attributeOne, attributeTwo, attributeThree);
			
			/*
				System.out.println("State One Next Object Index: " + stateOneNextObjectIndex);
				System.out.println("State Two Next Object Index: " + stateTwoNextObjectIndex);
				System.out.println("State One Next Object State: " + stateOneNextObjectState);
				System.out.println("State Two Next Object State: " + stateTwoNextObjectState);
				System.out.println("This Object Index: " + thisObjectIndex);			
			*/
		}

		
		void setAttributes(int attributeOne, int attributeTwo, int attributeThree)
		{
			this.attributeOne = attributeOne;
			this.attributeTwo = attributeTwo;
			this.attributeThree = attributeThree;
		}
		
		int returnAttribute(int attributeNumber)
		{
			int returnInt = 0;
			
			if (attributeNumber == 1)
			{
				returnInt = attributeOne;
			} 
			else if (attributeNumber == 2)
			{
				returnInt = attributeTwo;
			}
			else if (attributeNumber == 3)
			{
				returnInt = attributeThree;
			}
			return returnInt;
		}
			
		
		MachineObject(Object thisObject)
		{
			this.thisObject = thisObject;
		}

		Object returnObject()
		{
			return thisObject;
		}

		Integer returnNextObjectIndex(int currentState)
		{
			Integer returnInteger;
			
			if (currentState % 2 == 0)
			{
				returnInteger = new Integer(stateTwoNextObjectIndex);
			}
			else 
			//if (currentState % 2 == 1)
			{
				returnInteger = new Integer(stateOneNextObjectIndex);
			}
			
			return returnInteger;
		}
		
		Integer returnNextObjectState(int currentState)
		{
			Integer returnInteger;
			
			if (currentState % 2 == 0)
			{
				returnInteger = new Integer(stateTwoNextObjectState);
			}
			else 
			//if (currentState % 2 == 1)
			{
				returnInteger = new Integer(stateOneNextObjectState);
			}
			
			return returnInteger;
		}
						
		void setThisIndex(int thisObjectIndex)
		{
			this.thisObjectIndex = thisObjectIndex;
		}
		
		void setNextObjectIndex(int stateNextObjectIndex, int nextObjectState, int stateNumber)
		{
			
			if (stateNumber % 2 == 0)
			{
				stateTwoNextObjectIndex = stateNextObjectIndex;
				stateTwoNextObjectState = nextObjectState;
			}
			else
			{	
				stateOneNextObjectIndex = stateNextObjectIndex;
				stateOneNextObjectState = nextObjectState;
			}
			
		}		
	}
							
}